/*----------------------------------------------------------------------
  MainForm.c
  ----------------------------------------------------------------------
  Copyright (C). 2003 Smoky Monkey Factory All Rights Reserved
  http://andmore.jp/mobile/

  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

  $Id: MainForm.c,v 1.6 2003/07/20 01:58:37 zxn Exp $
  ----------------------------------------------------------------------*/

#include "MainForm.h"
#include "Etc.h"
#include "Prefs.h"
#include "SnapClip.h"
#include "SnapClipRsc.h"
#include "NotifyHandler.h"

extern prefsObj g_prefs;

static void _mainForm_Init(void);
static Boolean _mainForm_HandleMenu(UInt32 menu_id);
static Boolean _mainForm_HandleCtl(UInt32 ctl_id);
static Boolean _mainForm_HandlePop(UInt32 pop_id);

/*---------------------------------------------------------------------
  start main form
  ---------------------------------------------------------------------*/

void mainForm_Start(void)
{
  FrmGotoForm(MAIN_FORM_ID); /* xxx */
}

/*---------------------------------------------------------------------
  main form handler 
  ---------------------------------------------------------------------*/
Boolean mainFormEventHandler (EventPtr e)
{
    Boolean handled = false;

    switch (e->eType) 
      {
      case frmOpenEvent:
	_mainForm_Init();
	handled = true;
	break;

      case menuEvent:
	handled = _mainForm_HandleMenu(e->data.menu.itemID);
	break;

      case ctlSelectEvent:
	handled = _mainForm_HandleCtl(e->data.ctlSelect.controlID);
	break;

      case popSelectEvent:
	handled = _mainForm_HandlePop(e->data.popSelect.controlID); 
	break;

      default:
	break;
      }

    return handled;
}

/*=====================================================================
  private functions
  =====================================================================*/

/*---------------------------------------------------------------------
  init ctl objects
  ---------------------------------------------------------------------*/
static void _mainForm_Init(void)
{
  FormPtr frm;
 
  /* enabled */
  if (prefs_GetEnabled(g_prefs) == true)
    CtlSetValue (getObjectPtr (MAIN_BTN_ON_ID), 1);
  else
    CtlSetValue (getObjectPtr (MAIN_BTN_OFF_ID), 1);

  /* auto activate */
  CtlSetLabel(getObjectPtr (MAIN_POP_RESET_ID), 
	      LstGetSelectionText((ListPtr)getObjectPtr(MAIN_LIST_RESET_ID),
				  prefs_GetAutoActivate(g_prefs)));

  LstSetSelection(getObjectPtr(MAIN_LIST_RESET_ID), 
		  prefs_GetAutoActivate(g_prefs));

  /* draw form*/
  frm = FrmGetActiveForm();
  FrmDrawForm(frm);
}

/*---------------------------------------------------------------------
  handle menu 
  ---------------------------------------------------------------------*/
static Boolean _mainForm_HandleMenu(UInt32 menu_id)
{
  Boolean handled = true;
  FormPtr frm;

  MenuEraseStatus(NULL);

  switch(menu_id) 
    {
    case MAIN_CMD_ABOUT_ID:
      frm = FrmInitForm(ABOUT_FORM_ID);
      CtlSetLabel(FrmGetObjectPtr(frm, 
				  FrmGetObjectIndex(frm, ABOUT_LBL_VER_ID)),
		  SW_VERSION);
      FrmDoDialog(frm);
      FrmDeleteForm(frm);
      break;

#ifdef DEBUG
    case MAIN_CMD_DEBUG_ID:
      FrmDoDialog(getObjectPtr(ASK_ACTIVATE_FORM_ID));
      debugMessage("reset", "", prefs_GetAutoActivate(g_prefs));
      break;
#endif

    default:
      handled = false;
      break;
    }

  return handled;
}

/*---------------------------------------------------------------------
  handle menu 
  ---------------------------------------------------------------------*/
static Boolean _mainForm_HandleCtl(UInt32 ctl_id)
{
  Boolean handled = true;

  switch(ctl_id)
    {
    case MAIN_BTN_ON_ID:
      prefs_SetEnabled(g_prefs, true);
      prefs_SetFldEnter(g_prefs, false); // for safe
      prefs_Save(g_prefs);
      app_enableHack();
      break;

    case MAIN_BTN_OFF_ID:
      prefs_SetEnabled(g_prefs, false);
      prefs_Save(g_prefs); // for safe
      prefs_Save(g_prefs);
      app_disableHack();
      break;

    default:
      handled = false; 
      break;
    }

  return handled;
}

/*---------------------------------------------------------------------
  handle menu 
  ---------------------------------------------------------------------*/
static Boolean _mainForm_HandlePop(UInt32 pop_id)
{
  UInt16 selection;
  Boolean handled = true;

  switch(pop_id)
    {
    case MAIN_POP_RESET_ID:
      selection = LstGetSelection(getObjectPtr(MAIN_LIST_RESET_ID));
      if (selection == noListSelection)
	selection = 0;

      prefs_SetAutoActivate(g_prefs, selection);

      CtlSetLabel(getObjectPtr (MAIN_POP_RESET_ID), 
		  LstGetSelectionText((ListPtr)getObjectPtr(MAIN_LIST_RESET_ID),
				  prefs_GetAutoActivate(g_prefs)));


      break;

    default:
      handled = false;
      break;
    }

  return handled;
}
